WITH
T_MEM_BASE AS
(
SELECT d.name AS NOM_BASE,
       COUNT(*) * 8 / 1024.0 AS MEMOIRE_CACHE_MO
FROM   sys.dm_os_buffer_descriptors AS bd
       INNER JOIN sys.databases AS d
             ON bd.database_id = d.database_id
WHERE  d.name NOT IN ('master', 'model', 'msdb')
  AND  d.database_id <> 32767 -- Exclusion de la base "ressource"
GROUP  BY d.name
),
T_MEM_LIMIT AS
(
SELECT CASE
          WHEN CAST(value AS INT) < available_physical_memory_kb / 1024
             THEN CAST(value AS INT)
          ELSE available_physical_memory_kb / 1024
       END AS MEMORY_MO
FROM   sys.dm_os_sys_memory
       CROSS JOIN sys.configurations
WHERE  name = 'max server memory (MB)'
)
SELECT NOM_BASE, MEMOIRE_CACHE_MO,
       100.0 * (MEMOIRE_CACHE_MO / MEMORY_MO) AS USAGE_CACHE_POURCENT
FROM   T_MEM_BASE
CROSS  JOIN T_MEM_LIMIT
ORDER  BY 2 DESC;
--> ATENTION, cette requte ne fonctionne pas dans la version 2005 (la DMV sys.dm_os_sys_memory n'existe pas)